#ifndef __EventsInclude__
#define __EventsInclude__

/**
 * @file Events.h
 * @brief Single include for the Events package
 *
 * @date 23/08/2004
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: Events.h,v 1.3 2007/02/08 21:07:54 paul Exp $
 */

/**
 * @namespace Exponent::GUI::Events
 * @brief Events that can be generated by the Exponent graphics system
 *
 * Classes that can be used as notifier objects for the Exponent graphics system
 */

#include "CActionEvent.hpp"
#include "CDropEvent.hpp"
#include "CKeyboardEvent.hpp"
#include "CMenuEvent.hpp"
#include "CMouseEvent.hpp"
#include "CScrollEvent.hpp"

//	===========================================================================

#ifndef EXPONENT_COMPACT_BUILD
	using namespace Exponent::GUI::Events;
#endif

#endif	// Events